<html><body>
<?php
/*
  Copyright (C) 2003 Robert A. Wallis http://codetriangle.com

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.
*/

include "itunes_xml_parser.php";

$ituneslibrary = "Library.xml";

// filename is the xml file, cat prefix is something different for each time you call the function
// ie. DrawPlaylist("techno_playlist.xml", "techno-");
function DrawPlaylist($filename, $cat_prefix)
{
	$output = NULL;
	$totalsize = 0;

	// get "techno-f" and "tehcno-d" vars if they exsist
	// f stands for field, and d stants for direction
	$field = isset($_REQUEST[$cat_prefix."f"])?$_REQUEST[$cat_prefix."f"]:NULL;
	$direction = isset($_REQUEST[$cat_prefix."d"])?$_REQUEST[$cat_prefix."d"]:NULL;
	
	// load up the list of songs and sort
	$songs = iTunesXmlParser($filename, $field, $direction);
	
	// if the load was successful
	if ($songs)
	{
		// create an anchor so when the list is sorted, it comes back to where you are now
		$output .= "<a name=\"{$cat_prefix}\"></a>";
		
		// start a table
		$output .= "<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">";
			$output .= "<tr>";
			// for each field, create a link that will toggle up or down sorting direction
			// also add the anchor to the end of the link so when the page refreshes these
			// fields stay in the viewing area
			$output .= "<td><font size=\"1\"><a href=\"index.php?{$cat_prefix}f=Name&{$cat_prefix}d=".(($field=="Name")?(($direction=="up")?"down":"up"):"down")."#{$cat_prefix}\">name</a></font></td>";
			$output .= "<td><font size=\"1\"><a href=\"index.php?{$cat_prefix}f=Artist&{$cat_prefix}d=".(($field=="Artist")?(($direction=="up")?"down":"up"):"down")."#{$cat_prefix}\">artist</a></font></td>";
			$output .= "<td><font size=\"1\"><a href=\"index.php?{$cat_prefix}f=Album&{$cat_prefix}d=".(($field=="Album")?(($direction=="up")?"down":"up"):"down")."#{$cat_prefix}\">album</a></font></td>";
			//$output .= "<td><font size=\"1\"><a href=\"index.php?{$cat_prefix}f=Rating&{$cat_prefix}d=".(($field=="Rating")?(($direction=="up")?"down":"up"):"down")."#{$cat_prefix}\">rating</a></font></td>";
			$output .= "</tr>";
		
		// now actually get the songs
		foreach ($songs as $song)
		{
			if (!$shortestsong)
				$shortestsong = array($song["Name"],$song["Artist"],$song["Total Time"]);
			$curr_album = $song["Album"];
			$totalsize = $totalsize + $song["Size"];
			$totaltime = $totaltime + $song["Total Time"];
			if (!array_key_exists($song["Artist"], $artist)) {
				$artist[$song["Artist"]] = 1;
			} else {
				$artist[$song["Artist"]] ++;
			}
			if (!in_array($song["Album"], $album)) {
				$album[] = $song["Album"];
			}
			if ($song["Total Time"] > $longestsong[2])
				$longestsong = array($song["Name"],$song["Artist"],$song["Total Time"],$song["Album"]);
			if ($song["Total Time"] < $shortestsong[2])
				$shortestsong = array($song["Name"],$song["Artist"],$song["Total Time"],$song["Album"]);

			// display the field if the field is set

			$output .= "<tr>";

			if (($field == "Album" || $field == "Artist") && strcasecmp($curr_album,$prev_album)){
				$output .= "<td style=\"border-top: 1px solid black;\"><font size=\"2\">".(isset($song["Name"])?$song["Name"]:NULL)."</font></td>";
				$output .= "<td style=\"border-top: 1px solid black;\"><font size=\"2\">".(isset($song["Artist"])?$song["Artist"]:NULL)."</font></td>";
				$output .= "<td style=\"border-top: 1px solid black;\"><font size=\"2\">".(isset($song["Album"])?$song["Album"]:NULL)."</font></td>";
			} else {
				$output .= "<td><font size=\"2\">".(isset($song["Name"])?$song["Name"]:NULL)."</font></td>";
				$output .= "<td><font size=\"2\">".(isset($song["Artist"])?$song["Artist"]:NULL)."</font></td>";
				$output .= "<td><font size=\"2\">".(isset($song["Album"])?$song["Album"]:NULL)."</font></td>";
			}

			//$output .= "<td><font size=\"2\">".(isset($song["Rating"])?$song["Rating"]:NULL)."</font></td>";
			$output .= "</tr>";
			$prev_album = $song["Album"];
		}
		
		// end the table
		$output .= "</table>";
	}
	
	// show our results
	print ("<font size=\"2\">Number of Artists: ".count($artist)."</font><br />");
	print ("<font size=\"2\">Number of Songs: ".count($songs)."</font><br />");
	print ("<font size=\"2\">Number of Albums: ".count($album)."</font><br />");
	print ("<font size=\"2\">Size of Library: ". round($totalsize / 1073741824,2) ."GB</font><br />");

	$totaltime = intval(substr($totaltime,0,-3));

	print ("<font size=\"2\">Total play time: ");
	if ($totaltime > 86400){
		print(round($totaltime / 86400,2)." days");
	} elseif ($totaltime > 3600) {
		print(round($totaltime / 3600,2)." hours");
	} else {
		print(round($totaltime / 60,2)." minutes");
	}



	print("</font><br /><br />");

	$longestsong[2] = floor(intval(substr($longestsong[2],0,-3)) / 60).":".intval(substr($longestsong[2],0,-3)) % 60;
	print ("<font size=\"2\">Longest Song: ".$longestsong[0]." / ".$longestsong[1]." / ".$longestsong[3]." / ".$longestsong[2]."</font><br />");

	$shortestsong[2] = floor(intval(substr($shortestsong[2],0,-3)) / 60).":".intval(substr($shortestsong[2],0,-3)) % 60;
	print ("<font size=\"2\">Shortest Song: ".$shortestsong[0]." / ".$shortestsong[1]." / ".$shortestsong[3]." / ".$shortestsong[2]."</font><br />");

	arsort($artist);
	print ("<font size=\"2\">Artist With Most Songs: ".current(array_keys($artist))." - ".current($artist)." songs</font><br /><br />");
	
	print ($output);

}


// *****************
// now for each playlist you can have a separate table

DrawPlaylist($ituneslibrary, "");
?>
</body>
</html>